/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.io;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.localization.LogMessages;

public class ServerOutputBuffer
extends OutputBuffer {
    private Response serverResponse;

    public void initialize(Response response, FilterChainContext ctx) {
        super.initialize(response.getResponse(), response.isSendFileEnabled(), ctx);
        this.serverResponse = response;
    }

    @Override
    public void sendfile(File file, long offset, long length, CompletionHandler<WriteResult> handler) {
        if (!this.sendfileEnabled) {
            throw new IllegalStateException("sendfile support isn't available.");
        }
        boolean suspendedAtStart = this.serverResponse.isSuspended();
        CompletionHandler<WriteResult> ch = suspendedAtStart && handler != null ? handler : (!suspendedAtStart && handler != null ? this.suspendAndCreateHandler(handler) : this.createInternalCompletionHandler(file, suspendedAtStart));
        super.sendfile(file, offset, length, ch);
    }

    @Override
    public void recycle() {
        this.serverResponse = null;
        super.recycle();
    }

    @Override
    protected Executor getThreadPool() {
        return this.serverResponse.getRequest().getRequestExecutor();
    }

    private CompletionHandler<WriteResult> createInternalCompletionHandler(final File file, boolean suspendedAtStart) {
        if (!suspendedAtStart) {
            this.serverResponse.suspend();
        }
        CompletionHandler<WriteResult> ch = new CompletionHandler<WriteResult>(){

            @Override
            public void cancelled() {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_SERVEROUTPUTBUFFER_FILE_TRANSFER_CANCELLED(file.getAbsolutePath()));
                }
                ServerOutputBuffer.this.serverResponse.resume();
            }

            @Override
            public void failed(Throwable throwable2) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_SERVEROUTPUTBUFFER_FILE_TRANSFER_FAILED(file.getAbsolutePath(), throwable2.getMessage()), throwable2);
                }
                ServerOutputBuffer.this.serverResponse.resume();
            }

            @Override
            public void completed(WriteResult result2) {
                ServerOutputBuffer.this.serverResponse.resume();
            }

            @Override
            public void updated(WriteResult result2) {
            }
        };
        return ch;
    }

    private CompletionHandler<WriteResult> suspendAndCreateHandler(final CompletionHandler<WriteResult> handler) {
        this.serverResponse.suspend();
        return new CompletionHandler<WriteResult>(){

            @Override
            public void cancelled() {
                handler.cancelled();
                ServerOutputBuffer.this.serverResponse.resume();
            }

            @Override
            public void failed(Throwable throwable2) {
                handler.failed(throwable2);
                ServerOutputBuffer.this.serverResponse.resume();
            }

            @Override
            public void completed(WriteResult result2) {
                handler.completed(result2);
                ServerOutputBuffer.this.serverResponse.resume();
            }

            @Override
            public void updated(WriteResult result2) {
                handler.updated(result2);
            }
        };
    }
}

